﻿using System.Collections.Generic;
using System.Linq;

namespace DictionaryExamples
{
    // Listing 9-5. Zastosowanie słownika do przechowywania danych w pamięci podręcznej.
    class RecordCache
    {
        private Dictionary<int, Record> cachedRecords =
        new Dictionary<int, Record>();
        public Record GetRecord(int recordId)
        {
            Record result;
            if (cachedRecords.TryGetValue(recordId, out result))
            {
                // Znaleziono element w pamięci podręcznej, 
                // ale czy jest aktualny?
                if (IsStale(result))
                {
                    result = null;
                }
            }
            if (result == null)
            {
                result = LoadRecord(recordId);
                // Dodanie nowego wczytanego rekordu do pamięci podręcznej
                cachedRecords[recordId] = result;
            }
            DiscardAnyOldCacheEntries();
            return result;
        }
        private Record LoadRecord(int recordId)
        {
            //... Tu zostałby umieszczony kod do wczytywania rekordów ...
            return new Record();
        }
        private bool IsStale(Record result)
        {
            //... Tu zostałby umieszczony kod określający, czy rekord jest aktualny ...
            return false;
        }

        // Listing 9-10. Zapytanie LINQ, w którym słownik jest źródłem danych
        private void DiscardAnyOldCacheEntries()
        {
            // Wywołujemy ToList() na rzecz źródła danych, by potem operować 
            // na kopii enumeracji i by uniknąć wyjątku, który zostałby zgłoszony
            // ze względu na usuwanie elementów wewnątrz pętli foreach. 
            var staleKeys = from entry in cachedRecords.ToList()
                            where IsStale(entry.Value)
                            select entry.Key;
            foreach (int staleKey in staleKeys)
            {
                cachedRecords.Remove(staleKey);
            }
        }
    }
}
